chrome.runtime.onMessage.addListener(
  function(obj, sender, sendResponse) {
    if (obj.type === 'setting_feedback') {
      opentab()
    } else if (obj.type === 'taobaoImg') {
      getImg(obj.src, function(content) {
        sendResponse(content)
      })
    } else if (obj.type === "getTaobaoTrend") {
      request(obj.info, function(content) {
        sendResponse(content)
      })
    } else {
      request(obj.url, function(content) {
        sendResponse(content)
      })
    }
    return true;
  });

function getImg(url, callback) {
  var xmlhttp = new XMLHttpRequest();
  xmlhttp.responseType = 'blob';
  xmlhttp.addEventListener('load', function() {
    if (!xmlhttp.response) return;
    postMsg(xmlhttp.response, callback)
  })
  xmlhttp.open("GET", url, true);
  xmlhttp.send();
}

function postMsg(data, callback) {
  var str = "0123456789abcdefgABCDEFG";
  var imgName = "";
  for (var i = 0; i < 17; i++) {
    imgName += str.charAt(Math.round(Math.random() * 23))
  }
  var formData = new FormData();
  formData.append('imgfile', data, imgName + '.jpg');
  var xmlhttp = new XMLHttpRequest();
  xmlhttp.addEventListener('load', function() {
    try {
      var name = JSON.parse(xmlhttp.response).name;
    } catch (e) {
      var name = "";
    }
    buildUrl(name, callback)
  })
  xmlhttp.open("POST", 'https://s.taobao.com/image', true)
  xmlhttp.send(formData);
}

function opentab() {
  chrome.tabs.create({
    url: chrome.extension.getURL("html/setting_feedback.html")
  });
}

function buildUrl(name, callback) {
  console.log(name, 'name')
  if (!name || name == '') return;
  var y = (new Date()).getFullYear();
  var m = (new Date()).getMonth() + 1;
  var d = (new Date()).getDate();
  if (m < 10) m = '0' + m.toString()
  else m = m.toString();
  if (d < 10) d = '0' + d.toString()
  else d = d.toString();
  var datastr = 'staobaoz_' + y.toString() + m + d;
  var url = "https://s.taobao.com/search?q=&imgfile=&js=1&stats_click=search_radio_all%253A1&initiative_id=" + datastr + "&ie=utf8&tfsid=" + name + "&app=imgsearch";
  request(url, function(data) {
    var newdata = data.match(/\<script\>\s+g_page_config\s=\s(.*)/);
    if (newdata) newdata = newdata[1].match(/(\{.*\});/)
    if (newdata) newdata = newdata[1];
    callback(newdata)
  })
}

function requestPost(info, callback) {
  info = info.url;
  var url = "http://browserre.taotaosou.com/get_bd_comparision_info";
  var xml = new XMLHttpRequest()
  xml.addEventListener('load', function() {
    if (xml.responseText) {
      callback(xml.responseText)
    }
  })
  xml.open('POST', url);
  xml.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  xml.send(info)
}

function request(url, callback) {
  var xmlhttp = new XMLHttpRequest();
  xmlhttp.addEventListener('load', function() {
    callback(xmlhttp.responseText)
  })
  xmlhttp.open("GET", url, true);
  xmlhttp.send();
};
var blocks = {
  "urls": [
    "auto\\.alicdn\\.com/up/kirov/tmall\\.js"
  ],
  "csp-headers": [
    "mogujie",
    "vip.com"
  ]
};;
(function() {
  var blockConfig;
  try {
    blockConfig = blocks
    if (blockConfig && blockConfig.urls && blockConfig.urls.length) {
      chrome.webRequest.onBeforeRequest.addListener(function(details) {
        for (var i = 0; i < blockConfig.urls.length; i++) {
          var urlRE = blockConfig.urls[i]
          if (new RegExp(urlRE).test(details.url)) return {
            cancel: true
          };
        }
      }, {
        urls: ["<all_urls>"]
      }, ["blocking"]);
    }
    if (blockConfig['csp-headers']) {
      chrome.webRequest.onHeadersReceived.addListener(function(details) {
        for (var i = 0; i < blockConfig['csp-headers'].length; i++) {
          var urlRE = blockConfig['csp-headers'][i]
          if (new RegExp(urlRE).test(details.url)) {
            for (var i = 0; i < details.responseHeaders.length; i++) {
              if (details.responseHeaders[i].name.match(/(?:Content-Security-Policy|X-Content-Security-Policy|X-WebKit-CSP)/)) {
                details.responseHeaders.splice(i, 1);
              }
            }
            return {
              responseHeaders: details.responseHeaders
            };
          }
        }
      }, {
        urls: ["<all_urls>"]
      }, ["blocking", "responseHeaders"]);
    }
  } catch (e) {}
})();